import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

@SuppressWarnings("serial")
public class BasicCannon extends JPanel implements KeyListener, ActionListener
{
	public static int WIDTH=800;
	public static int HEIGHT=600;
    private Font titleFont, regularFont;
    private Timer timer;
    private String message;
	private int angle;
	private int force;
	private int ammo;
	private int powder;
	private ArrayList<CannonBall> balls;
	private ArrayList<Rectangle> targets;
	public static final int FLOOR=550;
	
    public BasicCannon()
    {
    	
    	//initialize variables here...
    	titleFont = new Font("Roman", Font.BOLD, 18);
    	regularFont = new Font("Helvetica", Font.PLAIN, 12);
    	timer = new Timer(10, this);
    	message="Basic Cannon: Use arrow keys and space bar";

        addKeyListener(this);
        timer.start();
        angle=45;
        force=50;
        ammo=200;
        powder=5000;
        balls = new ArrayList<CannonBall>();
        targets = new ArrayList<Rectangle>();
        for(int i=120; i< 800-40; i+=40){
                targets.add(new Rectangle (i, FLOOR, 30, 10));
        }
    }
	public static void main(String[] args) {
		BasicCannon app= new BasicCannon();
		JFrame window = new JFrame("My Generic Application");
		window.setSize(WIDTH, HEIGHT);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		window.getContentPane().add(app);
		window.addKeyListener(app);
		//window.pack();
		window.setVisible(true);
		
	}
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		g.setColor(Color.BLACK);
		g.fillRect(0, 0, getWidth(),getHeight());
		g.setColor(Color.BLUE);
		g.setFont(titleFont);
		g.drawString("Basic Canon Defender", 420, 20);
		g.setColor(Color.WHITE);
		g.setFont(regularFont);
		g.drawString("Version 1.0", 420, 40);
		g.drawString(message, 20, 20);
        g.drawString(" Angle: "+angle, 20, 40);
        g.drawString(" Force: "+force, 20, 60);
        g.setColor(Color.YELLOW);
        g.drawString("  Ammo: "+ammo, 420, 60);
        g.drawString("Powder: "+powder, 420, 80);
        drawCastle(g);
        for(CannonBall b:balls)
            b.draw(g);
        g.setColor(Color.YELLOW);
        for(Rectangle t:targets)
            g.fillRect(t.x, t.y, t.width, t.height);
		
	}
	
	public void drawCastle(Graphics g)
    {
        g.setColor(Color.LIGHT_GRAY);
        Polygon castle = new Polygon();
        castle.addPoint(80, 260);
        castle.addPoint(120, 260);
        castle.addPoint(120, 270);
        castle.addPoint(110, 280);
        castle.addPoint(110, FLOOR);
        castle.addPoint(90, FLOOR);
        castle.addPoint(90, 280);
        castle.addPoint(80, 270);
        g.fillPolygon(castle);
    }
    
    private void gameOverCheck() 
    {
        if (targets.size() == 0)
        {
            message = "You win with "+ammo+" cannonballs and "+powder+" gunpowder left!";
        }
        else if (ammo == 0 && powder == 0)
        {
            message = "Game Over-- out of cannonballs and gunpowder";
        }
        else if (ammo == 0)
        {
            message = "Game Over-- out of cannonballs";
        }
        else if (powder == 0)
        {
            message = "Game Over-- out of gunpowder";
        }
    }
	// update is a workaround to cure Windows screen flicker problem
	public void update(Graphics g){
		paint(g);
	}

	// These 3 methods need to be declared to implement the KeyListener Interface
	public void keyTyped(KeyEvent e) {
    }
    public void keyPressed(KeyEvent e) {
        int key=e.getKeyCode();
        if (key==KeyEvent.VK_DOWN ){
            angle--;
            if (angle<0)
                angle=0;
        }else if(key==KeyEvent.VK_UP){
            angle++;
            if (angle>90)
                angle=90;
        }else if(key==KeyEvent.VK_SPACE){

            if(powder-force<0){
                force=powder;
                powder=0;
            }else{
                powder-=force;
            }

            if (ammo>0 && force>0){ //fire!
                balls.add(new CannonBall(angle, force));
            }
            ammo--;
            if(ammo<0){
                ammo=0;
            }
        }else if(key==KeyEvent.VK_LEFT){
            force--;
            if(force<0)
                force=0;
        }else if(key==KeyEvent.VK_RIGHT){
            force++;
            if(force>100)
                force=100;
        }

        repaint();
    }


    public void keyReleased(KeyEvent e) {}
    //  The Timer produces Action events
    public void actionPerformed(ActionEvent e) {
        for(CannonBall b:balls)
            b.move(targets);

        int i=0;
        while(i<balls.size()){
            CannonBall b=balls.get(i);
            if (b.getY()>FLOOR)
                balls.remove(b);
            else
                i++;
        }
        gameOverCheck();
        repaint();

    }
}

